<?php
if (session_status() === PHP_SESSION_NONE) session_start();

function e($str) {
  return htmlspecialchars((string)$str, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}

function csrf_token() {
  if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
  }
  return $_SESSION['csrf_token'];
}

function csrf_field() {
  $t = csrf_token();
  echo '<input type="hidden" name="csrf_token" value="'.e($t).'">';
}

function verify_csrf() {
  $ok = isset($_POST['csrf_token']) && hash_equals($_SESSION['csrf_token'] ?? '', $_POST['csrf_token']);
  if (!$ok) {
    http_response_code(400);
    echo "Invalid CSRF token";
    exit;
  }
}

function redirect($path) {
  header('Location: ' . $path);
  exit;
}
