<?php
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../helpers.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo json_encode(['error' => 'Method not allowed']);
  exit;
}

verify_csrf();

$action = $_POST['action'] ?? '';
$name = trim($_POST['name'] ?? '');

try {
  if ($action === 'add_category') {
    if ($name === '') throw new Exception('Name required');
    $stmt = $pdo->prepare("INSERT IGNORE INTO categories(name) VALUES(?)");
    $stmt->execute([$name]);
    // fetch id
    $id = (int)$pdo->lastInsertId();
    if ($id === 0) {
      // already existed
      $stmt = $pdo->prepare("SELECT id FROM categories WHERE name=?");
      $stmt->execute([$name]);
      $id = (int)($stmt->fetchColumn() ?: 0);
    }
    echo json_encode(['id'=>$id, 'name'=>$name]);
    exit;
  }

  if ($action === 'add_device') {
    if ($name === '') throw new Exception('Name required');
    $stmt = $pdo->prepare("INSERT IGNORE INTO devices(name) VALUES(?)");
    $stmt->execute([$name]);
    $id = (int)$pdo->lastInsertId();
    if ($id === 0) {
      $stmt = $pdo->prepare("SELECT id FROM devices WHERE name=?");
      $stmt->execute([$name]);
      $id = (int)($stmt->fetchColumn() ?: 0);
    }
    echo json_encode(['id'=>$id, 'name'=>$name]);
    exit;
  }

  throw new Exception('Unknown action');
} catch (Throwable $e) {
  http_response_code(400);
  echo json_encode(['error' => $e->getMessage()]);
}
