<?php
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../helpers.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$editing = $id > 0;

// Load options
$categories = $pdo->query("SELECT id, name FROM categories ORDER BY name")->fetchAll();
$devices = $pdo->query("SELECT id, name FROM devices ORDER BY name")->fetchAll();

$product = ['name'=>'','sku'=>'','category_id'=>null,'price'=>null,'description'=>''];
$selectedDevices = [];

if ($editing) {
  $stmt = $pdo->prepare("SELECT * FROM products WHERE id=?");
  $stmt->execute([$id]);
  $product = $stmt->fetch() ?: $product;

  $stmt = $pdo->prepare("SELECT device_id FROM product_devices WHERE product_id=?");
  $stmt->execute([$id]);
  $selectedDevices = array_column($stmt->fetchAll(), 'device_id');
}

// Handle save
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'save') {
  verify_csrf();
  $name = trim($_POST['name'] ?? '');
  $sku = trim($_POST['sku'] ?? '');
  $category_id = ($_POST['category_id'] ?? '') !== '' ? (int)$_POST['category_id'] : null;
  $price = ($_POST['price'] ?? '') !== '' ? (float)$_POST['price'] : null;
  $description = trim($_POST['description'] ?? '');
  $devs = array_map('intval', $_POST['devices'] ?? []);

  if ($name === '') $error = 'Name is required';
  else {
    $pdo->beginTransaction();
    try {
      if ($editing) {
        $stmt = $pdo->prepare("UPDATE products SET name=?, sku=?, category_id=?, price=?, description=? WHERE id=?");
        $stmt->execute([$name, $sku ?: null, $category_id, $price, $description, $id]);

        $pdo->prepare("DELETE FROM product_devices WHERE product_id=?")->execute([$id]);
        if (!empty($devs)) {
          $ins = $pdo->prepare("INSERT INTO product_devices(product_id, device_id) VALUES(?, ?)");
          foreach ($devs as $d) $ins->execute([$id, $d]);
        }
      } else {
        $stmt = $pdo->prepare("INSERT INTO products(name, sku, category_id, price, description) VALUES(?,?,?,?,?)");
        $stmt->execute([$name, $sku ?: null, $category_id, $price, $description]);
        $newId = (int)$pdo->lastInsertId();
        if (!empty($devs)) {
          $ins = $pdo->prepare("INSERT INTO product_devices(product_id, device_id) VALUES(?, ?)");
          foreach ($devs as $d) $ins->execute([$newId, $d]);
        }
      }
      $pdo->commit();
      redirect('products.php');
    } catch (Throwable $e) {
      $pdo->rollBack();
      $error = 'Save failed: ' . $e->getMessage();
    }
  }
}

include __DIR__.'/header.php';
$csrf = csrf_token();
?>
<div class="card">
  <h2><?= $editing ? 'Edit' : 'Add' ?> Product</h2>
  <?php if (!empty($error)): ?>
    <div class="badge" style="background:#fee2e2; color:#991b1b; margin-bottom:8px;"><?= e($error) ?></div>
  <?php endif; ?>
  <form method="post">
    <?php csrf_field(); ?>
    <input type="hidden" name="action" value="save">

    <div class="form-row">
      <label>Name *</label>
      <input type="text" name="name" value="<?= e($product['name'] ?? '') ?>" required>
    </div>

    <div class="form-row">
      <label>SKU</label>
      <input type="text" name="sku" value="<?= e($product['sku'] ?? '') ?>">
    </div>

    <div class="form-row">
      <label>Category</label>
      <div class="inline">
        <select name="category_id" id="category_id">
          <option value="">— None —</option>
          <?php foreach ($categories as $c): ?>
            <option value="<?= e($c['id']) ?>" <?= ($product['category_id'] ?? null) == $c['id'] ? 'selected' : '' ?>>
              <?= e($c['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
        <button type="button" class="btn secondary" onclick="toggleNewField('newCatBox')">+ New</button>
      </div>
      <div id="newCatBox" class="hidden" style="margin-top:8px;">
        <div class="inline">
          <input type="text" id="new_category_name" placeholder="New category name">
          <button type="button" class="btn" onclick="quickAdd('add_category','new_category_name','category_id','<?= e($csrf) ?>')">Save</button>
        </div>
        <div class="small">Quick-add creates and selects the new category.</div>
      </div>
    </div>
    <div class="form-row">
      <label>Compatible Devices</label>

      <div class="msel">
        <div class="msel-toggle">
          <span class="hint">Select devices…</span>
          <span>▾</span>
        </div>

        <div class="msel-chips"></div>

        <div class="msel-panel hidden">
          <input type="text" class="msel-search" placeholder="Search devices by name…">

          <div class="msel-list">
            <?php foreach ($devices as $d): 
              $nm = $d['name'];
              $idv = (int)$d['id'];
              $checked = in_array($idv, $selectedDevices) ? 'checked' : '';
            ?>
              <label class="msel-item" data-label="<?= e(strtolower($nm)) ?>">
                <input type="checkbox" name="devices[]" value="<?= e($idv) ?>" data-label="<?= e($nm) ?>" <?= $checked ?>>
                <span><?= e($nm) ?></span>
              </label>
            <?php endforeach; ?>
            <div class="msel-empty" style="display:none;">No matching devices</div>
          </div>

          <div class="msel-actions">
            <input type="text" id="msel-add-input" class="msel-search" placeholder="Quick add new device…">
            <button type="button" class="btn secondary" id="msel-add-btn" data-csrf="<?= e($csrf) ?>">+ Add</button>
          </div>
        </div>
      </div>
    </div>



    <div class="form-row">
      <label>Price</label>
      <input type="number" step="0.01" name="price" value="<?= e($product['price'] ?? '') ?>">
    </div>

    <div class="form-row">
      <label>Description</label>
      <textarea name="description" rows="4"><?= e($product['description'] ?? '') ?></textarea>
    </div>

    <div class="flex" style="justify-content:flex-end;">
      <a class="btn secondary" href="products.php">Cancel</a>
      <button class="btn">Save</button>
    </div>
  </form>
</div>

<?php include __DIR__.'/footer.php'; ?>
